#COMPILE EXE
#DIM ALL
#INCLUDE ONCE "Win32Api.inc"
%ONum = 2
%INum = 3
'--------------------------------------------------------------------------------------------------+
'- Get only Property Macro                                                                         |
'--------------------------------------------------------------------------------------------------+
MACRO GProp(pName, varType) = PROPERTY GET pName() AS varType: PROPERTY = pName: END PROPERTY

'--------------------------------------------------------------------------------------------------+
'- Set only Property Macro                                                                         |
'--------------------------------------------------------------------------------------------------+
MACRO SProp(pName, varType) = PROPERTY SET pName(BYREF v AS varType): pName = v: END PROPERTY

'--------------------------------------------------------------------------------------------------+
'- Get/Set Property Macro                                                                          |
'--------------------------------------------------------------------------------------------------+
MACRO GSProp(pName, varType) = GProp(pName, varType): SProp(pName, varType)

'--------------------------------------------------------------------------------------------------+
'- License Stuff                                                                                   |
'-                                                                                                 |
'-                                                                                                 |
'-   SPFLite is free software: you can redistribute it and/or modify                               |
'-   it under the terms of the GNU General Public License as published by                          |
'-   the Free Software Foundation, either version 3 of the License, or                             |
'-   (at your option) any later version.                                                           |
'-                                                                                                 |
'-   SPFLite is distributed in the hope that it will be useful,                                    |
'-   but WITHOUT ANY WARRANTY; without even the implied warranty of                                |
'-   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                                 |
'-   GNU General Public License for more details.                                                  |
'-                                                                                                 |
'-   You should have received a copy of the GNU General Public License                             |
'-   along with SPFLite.  If not, see <https://www.gnu.org/licenses/>.                             |
'-                                                                                                 |
'--------------------------------------------------------------------------------------------------+
'- DataLione.INC                                                                                   |
'--------------------------------------------------------------------------------------------------+

'--------------------------------------------------------------------------------------------------+
'- Main Text storage Data                                                                          |
'--------------------------------------------------------------------------------------------------+
CLASS cDataLine
   INSTANCE LLbl    AS STRING                                     ' Label
   INSTANCE LLNum   AS STRING                                     ' Original line number at last AttnFlag refresh
   INSTANCE LLCtl   AS STRING                                     ' Line control after KB interaction
   INSTANCE LTag    AS STRING                                     ' Tag
   INSTANCE LHndl   AS LONG                                       ' Handle number
   INSTANCE LTrak   AS LONG                                       ' Track Point ID
   INSTANCE LFlag   AS LONG                                       ' Type of entry
   INSTANCE LWrk1   AS LONG                                       ' Misc. work value (e.g. XX count)
   INSTANCE LWrk2   AS LONG                                       ' Work value. =PAGE> ctr; Note type
   INSTANCE LCol    AS LONG                                       ' Column number if %Cursor line
   INSTANCE LFix    AS LONG                                       ' FIND index counter
   INSTANCE LMix    AS LONG                                       ' MultiEdit File Index
   INSTANCE LTxt    AS STRING                                     ' The actual text string
   INSTANCE LAttr   AS WSTRING                                    ' The attributes for the string

   INTERFACE iDataLine: INHERIT IUNKNOWN                          '
      GSProp(LLbl,  STRING)                                       ' Label
      GSProp(LLNum, STRING)                                       ' Original line number at last AttnFlag refresh
      GSProp(LLCtl, STRING)                                       ' Line control after KB interaction
      GSProp(LTag,  STRING)                                       ' Tag
      GSProp(LHndl, LONG)                                         ' Handle number
      GSProp(LTrak, LONG)                                         ' Track Point ID
      GSProp(LFlag, LONG)                                         ' Type of entry
      GSProp(LWrk1, LONG)                                         ' Misc. work value (e.g. XX count)
      GSProp(LWrk2, LONG)                                         ' Work value. =PAGE> ctr; Note type
      GSProp(LCol,  LONG)                                         ' Column number if %Cursor line
      GSProp(LFix,  LONG)                                         ' FIND index counter
      GSProp(LMix,  LONG)                                         ' MultiEdit File Index
      GSProp(LTxt,  STRING)                                       ' The actual text string
      GSProp(LAttr, WSTRING)                                      ' The attributes for the string
   END INTERFACE                                                  '
END CLASS

CLASS cObjTabData
   INSTANCE L()       AS iObjTabData

   INTERFACE iObjTabData: INHERIT IUNKNOWN

      METHOD Init(x AS LONG, y AS LONG)
         LOCAL i, j AS LONG
         DIM L(1 TO y) AS INSTANCE iDataLine
         FOR i = 1 TO y
            LET L(i) = CLASS "CDataLine"
            me.L_(i).LTxt = "L : " + STR$(i)
         NEXT i
      END METHOD

      METHOD L_(i AS LONG) AS iDataLine                                         '
         METHOD = L(i)                                             '
      END METHOD                                                  '

   END INTERFACE
END CLASS

GLOBAL Tabs() AS iObjTabData                       ' Table of Outers
GLOBAL TP     AS iObjTabData                       ' Working TP

FUNCTION PBMAIN () AS LONG
DIM Tabs(1 TO 2) AS iObjTabData
LOCAL i, j AS LONG
   FOR i = 1 TO %oNum                               ' Build Outer
      LET Tabs(i) = CLASS "cObjTabData"             '
      Tabs(i).Init(i, %iNum)                        ' Call Init to build Inner
   NEXT i

   FOR i = 1 TO %oNum
      TP = Tabs(i)                                  ' Ptr to current

      FOR j = 1 TO %iNum                            ' Now change it back
         debug "(Before) iTxt " + TP.L_(j).LTxt     ' Dump it
         TP.L_(j).LTxt = "Done"                     ' Change it
         debug "(After)  iTxt " + TP.L_(j).LTxt     ' Dump it again
      NEXT j

      FOR j = 1 TO %iNum                            ' Now change it back
         debug "(Before) iTxt " + TP.L_(j).LTxt     ' Dump it
         TP.L_(j).LTxt = "L : " + STR$(j)           ' Change it
         debug "(After)  iTxt " + TP.L_(j).LTxt     ' Dump it again
      NEXT j
      debug "============="
   NEXT i

   MSGBOX "OK"
END FUNCTION

SUB      DEBUG (st AS STRING)
STATIC Hwnd AS DWORD
LOCAL szConsole AS ASCIIZ * 1024
   IF Hwnd = 0 THEN AllocConsole: Hwnd = GetStdHandle(%STD_OUTPUT_HANDLE)
   IF Hwnd > 0 THEN szConsole = st & $CRLF: WriteConsole Hwnd, szConsole, LEN(szConsole), %NULL, %NULL
END SUB
